/*  Prüft die Einträge der Tabelle "scheduling.resource_timeline" vom Typ "off.time" auf logische Inkonsistenzen.
    Diese Funktion wird üblicherweise als Unterfunktion der DB-Funktion "scheduling.resource_timeline__validate_block" gerufen.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__validate_block_off_time', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__validate_block_off_time(
    _block scheduling.resource_timeline
) RETURNS jsonb AS $$
DECLARE
    _ksvba_id int := context_id FROM scheduling.resource WHERE id = _block.ti_resource_id and context = 'ksvba';
    _issues jsonb := '{ "has_issues": false, "issues":[] }';
BEGIN

    IF ( _block.ti_type <> 'off.time' ) THEN
        RAISE EXCEPTION 'invalid block type, id % is not of type off.time', _block.ti_id;
    END IF;

    IF ( _block.ti_usage <> 1 ) THEN

        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"load not equal to 1"' ) ;

    END IF;

    IF (
      NOT _block.ti_date_start::time IN (
        '00:00:00'::time,
        -- end of shift = start of block
        (scheduling.ksvba__get_shifttimes( _ksvba_id ))[2]
      )
    ) THEN

        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"start time out of sync"' ) ;

    END IF;

    IF (
      NOT _block.ti_date_end::time IN (
        '00:00:00'::time,
        -- start of shift = end of block
        (scheduling.ksvba__get_shifttimes( _ksvba_id ))[1]
      )
    ) THEN

        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"end time out of sync"' ) ;

    END IF;

    RETURN _issues;

END $$ language plpgsql;
